	[G, Z, P] = BW_POLES_Z2(wcT, wsT, Amax, Amin, N)
	
	% 	Computes the denormalized poles, zeros, and gain constant for  
	%	a digital lowpass Butterworth filter directly in the z-plane. 
	%	The design margin is used to decrease the stopband edge.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-08
	% 	Modified by: 	LW
	% 	Version: 		1
	% 	Known bugs:
	% 	Copyright:		by authors - not released for commercial use	
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	aconstant = tan(wcT/2); 
	epsilon = sqrt(10^(Amax/10)-1);
	k = 1:N;
	pol = exp(j*pi*(1/2+(2*k-1)/(2*N)))/(epsilon^(1/N)); 
	P = (1+aconstant*pol)./(1-aconstant*pol);
	zero_angles(k) = pi;
	Z = exp(j*zero_angles);
	G = real(prod(1-P))/real(prod(1-exp(j*zero_angles)));
	
